
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1304.C - Message 1304 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1304 messages.
//
//
//   REVISION HISTORY
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

void wait(float);  
void clear_message_line(void);   

/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1304 message from the ZMsgBuf.
//
void Dec1304(tMSGBUF *ZMsgBuf, tMSG1304 *Msg)
{
; // whatever
}                                      

end not needed yet */
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1304 message in the ZMsgBuf.
//
void Bld1304(tMSGBUF *ZMsgBuf, tMSG1304 *Msg)
{
 
   // build the header in the buffer
   PutShort  (0x81FF                         , ZMsgBuf, 1);     // message preamble
   PutShort  (1304                           , ZMsgBuf, 2);     // message number
   PutShort  (1                              , ZMsgBuf, 3);     // message length
   PutShort  (ANREQ                          , ZMsgBuf, 4);     // message ack/nack request
   PutShort  (0x5A5B                         , ZMsgBuf, 6);     // put in some seq number                                 
}                                            


/* not needed yet
////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1380 message from the ZMsgBuf.
//
void Show1380(tMSG1380 *Msg)
{
; // whatever
}                                                 

end not needed yet */
